[![Build Status](https://travis-ci.com/processing/p5.js-sound.svg?branch=master)](https://travis-ci.com/processing/p5.js-sound) 

![](https://cloud.githubusercontent.com/assets/504124/19908328/2cd874ea-a059-11e6-847c-e5da5e957a2f.jpg)

p5.sound
========
[![Gitter](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/processing/p5.js-sound?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)

p5.sound brings the [Processing](http://processing.org) approach to [Web Audio](http://w3.org/TR/webaudio/) as an addon for [p5.js](http://github.com/lmccart/p5.js). Functionality includes audio input, playback, manipulation, effects, recording, sequencing, analysis and synthesis. The library is designed to be used in tandem with [p5.js](http://p5js.org).

### Examples
* Examples at [p5js.org/examples](https://p5js.org/examples/)
* Additional examples at [processing.github.io/p5.js-sound](https://processing.github.io/p5.js-sound/)
* p5.js Sound Tutorial by Dan Shiffman on [YouTube](https://www.youtube.com/playlist?list=PLRqwX-V7Uu6aFcVjlDAkkGIixw70s7jpW)

### [Documentation](http://p5js.org/reference/#/libraries/p5.sound)
Interactive documentation at [p5js.org/reference/#/libraries/p5.sound](http://p5js.org/reference/#/libraries/p5.sound)



### Latest Build
* Visit http://p5js.org/download/ for the latest official release of p5 with the latest p5.sound included.
* The sound library [here](https://github.com/processing/p5.js-sound/blob/master/lib) is updated more frequently, and we occasionally offer new [releases](https://github.com/processing/p5.js-sound/releases) before p5's release cycle.


### Contribute
[Here's a guide](https://github.com/processing/p5.js-sound/wiki/Contribute) to getting started as a contributor.


### Dependencies
p5.sound is built with a few modules (Clock, TimelineSignal, and signal math components) from [Tone.js](https://github.com/tonejs/Tone.js), an interactive music framework developed by Yotam Mann.

### References and Inspiration
- [Yotam Mann & TONE.js](https://github.com/tonejs/Tone.js)
- [Boris Smus Web Audio API book](http://smus.com/webaudio-book/)
- [wavesurfer.js](https://github.com/katspaugh/wavesurfer.js)
- [Web Audio Components](https://github.com/web-audio-components)
- [buzz.js](http://buzz.jaysalvat.com/)
- [Chris Wilson](https://github.com/cwilso/)
- [Chris Lowis](http://blog.chrislowis.co.uk/)
- [Kevin Ennis](https://github.com/kevincennis)
- [Wilm Thoben's Sound library for Processing](https://github.com/processing/processing/tree/master/java/libraries/sound)
- [Web Audio API](http://webaudio.github.io/web-audio-api/)
