// Adapted from Learning Processing
// Daniel Shiffman
// http://www.learningprocessing.com

// in the previous example, we created an Amplitude object to getLevel().
// AudioIn contains its own internal amplitude object, so we can actually
// just call getLevel on the AudioIn itself.

var input;
var analyzer;

function setup() {
  createCanvas(200, 200);
  background(255);

  // Create an Audio input
  input = new p5.AudioIn();

  input.start();
}

function draw() {
  // Get the overall volume (between 0 and 1.0)
  var volume = input.getLevel();

  // If the volume is greater than 0.1 a rectangle is drawn at a random location in the window. 
  // The louder the volume, the larger the rectangle.
  var threshold = 0.1;
  if (volume > threshold) {
    stroke(0);
    fill(0, 100);
    rect(random(40, width), random(height), volume*50, volume*50);
  }

  // Graph the overall potential volume, with a line at the threshold
  var y = map(volume, 0, 1, height, 0);
  var ythreshold = map(threshold, 0, 1, height, 0);

  noStroke();
  fill(175);
  rect(0, 0, 20, height);
  // Then draw a rectangle on the graph, sized according to volume
  fill(0);
  rect(0, y, 20, y);
  stroke(0);
  line(0, ythreshold, 19, ythreshold);
}